CRegExpElpas
RegExpElpas
CRegExpElex
RegExpElex

// first four line must be compact

// #include
{*
#include <string.h>
#include <stdio.h>
#include <stack>
#include "FiniteAutomata.h"
*}

// user definition
{*
stack<int> cCaseDCStack;
stack<int> cBrackStack;
int iCaseDC = 0;
int iBrack = 0;
*}

<RE>

// predef : NAME, NAMELEN, ARG1, ARG2, ..., RETURN

// eg) a, _, "STR", (a*), a-b
<ONE>			-> ESCCHR {*
	RETURN (char) ((char*) SYM0)[0];
*};

<ONE>			-> SHPCHR {*
	RETURN (char) ((char*) SYM0)[0];
*};

<ONE>			-> NORCHR {*
	RETURN (char) ((char*) SYM0)[0];
*};

<PRIME>			-> <ONE> {*
	if (iCaseDC) {
		RETURN NFA_e::createCharCaseDC((char) SYM0);
	} else {
		RETURN NFA_e::createChar((char) SYM0);
	} 
*};

<PRIME>			-> ANY {*
	RETURN NFA_e::createAny();
*};

<PRIME>			-> STRING {*
	if (strlen((char*) SYM0)) {
		RETURN NFA_e::createString((char*) SYM0);
	} else {
		RETURN NFA_e::createNull();
	}
*};

<PRIME>			-> <ONE> RANGE <ONE>
{*
	RETURN NFA_e::createRange((char) SYM0, (char) SYM2);
*};

<PRIME>			-> LPAREN <RE> RPAREN
{*
	cBrackStack.push(iBrack);
	iBrack = 0;
*}
{*
	RETURN SYM1;
	iBrack = cBrackStack.top();
	cBrackStack.pop();
*};

<PRIME>			-> LBRACK <RE> RBRACK
{*
	cBrackStack.push(iBrack);
	iBrack = 1;
*}
{*
	RETURN SYM1;
	iBrack = cBrackStack.top();
	cBrackStack.pop();
*}
;

<PRIME>			-> LBRACE <RE> RBRACE
{*
	cCaseDCStack.push(iCaseDC);
	iCaseDC = 1;
*}
{*
	RETURN SYM1;
	iCaseDC = cCaseDCStack.top();
	cCaseDCStack.pop();
*};

<CLOSUREOP>		->
{*
	RETURN 0;
*};

<CLOSUREOP>		-> NOT <CLOSUREOP>
{*
	char* pBack = (char*) SYM1;
	char* pTemp;

	if (pBack) {
		pTemp = new char[2 + strlen(pBack)];
		strcpy(pTemp + 1, pBack);
		delete[] pBack;
	} else {
		pTemp = new char[2];
		pTemp[1] = 0;
	}
	pTemp[0] = ((char*) SYM0)[0];

	RETURN pTemp;
*};

<CLOSUREOP>		-> ONE_OR_ZERO <CLOSUREOP>
{*
	char* pBack = (char*) SYM1;
	char* pTemp;

	if (pBack) {
		pTemp = new char[2 + strlen(pBack)];
		strcpy(pTemp + 1, pBack);
		delete[] pBack;
	} else {
		pTemp = new char[2];
		pTemp[1] = 0;
	}
	pTemp[0] = ((char*) SYM0)[0];

	RETURN pTemp;
*};

<CLOSUREOP>		-> CLOSURE_ONE_OR_MORE <CLOSUREOP>
{*
	char* pBack = (char*) SYM1;
	char* pTemp;

	if (pBack) {
		pTemp = new char[2 + strlen(pBack)];
		strcpy(pTemp + 1, pBack);
		delete[] pBack;
	} else {
		pTemp = new char[2];
		pTemp[1] = 0;
	}
	pTemp[0] = ((char*) SYM0)[0];

	RETURN pTemp;
*};

<CLOSUREOP>		-> CLOSURE_ZERO_OR_MORE <CLOSUREOP>
{*
	char* pBack = (char*) SYM1;
	char* pTemp;

	if (pBack) {
		pTemp = new char[2 + strlen(pBack)];
		strcpy(pTemp + 1, pBack);
		delete[] pBack;
	} else {
		pTemp = new char[2];
		pTemp[1] = 0;
	}
	pTemp[0] = ((char*) SYM0)[0];

	RETURN pTemp;
*};

// eg) a*, a+*, (a)~, A-Z+
<CLOSURE>		-> <PRIME> <CLOSUREOP>
{*
	if (SYM1 == 0) {
		// simply prime expression
		RETURN SYM0;
	} else {
		NFA_e *a = (NFA_e*) SYM0, *b;
		int i = 0;
		char* pTemp = (char*) SYM1;
		while(pTemp[i]) {
			switch(pTemp[i]) {
			case '?':
				b = NFA_e::createAlt(a);
				break;
			case '+':
				b = NFA_e::createPClosure(a);
				break;
			case '*':
				b = NFA_e::createClosure(a);
				break;
			case '~':
				b = NFA_e::createNot(a);
				break;
			}
			delete a;
			a = b;
			i++;
		}
		RETURN a;
		delete[] (char*) SYM1;
	}
*};

<ALTER>			-> <CLOSURE> OR <ALTER>
{*
	RETURN NFA_e::createOr((NFA_e*) SYM0, (NFA_e*) SYM2);
*};

<ALTER>			-> <CLOSURE>
{*
	RETURN SYM0;
*};

<CONCAT>		->
{*
	RETURN 0;
*};

<CONCAT>		-> <ALTER> <CONCAT>
{*
	if (SYM1 == 0) {
		RETURN SYM0;	
	} else {
		if (!iBrack) {
			RETURN NFA_e::createConcat((NFA_e*) SYM0, (NFA_e*) SYM1);
		} else {
			RETURN NFA_e::createOr((NFA_e*) SYM0, (NFA_e*) SYM1);
		}
		delete (NFA_e*) SYM0;
		delete (NFA_e*) SYM1;
	}
*};

<RE>			-> <CONCAT>
{*
	RETURN SYM0;
*};
